onEvent('recipes', event => {
	// Create
	const {
		createFilling,
		createMixing,
		createCrushing,
		createSequencedAssembly,
		createDeploying,
		createMechanicalCrafting,
		createSplashing
	} = event.recipes;
	// Vanilla
	const {
		shaped,
		smithing,
		stonecutting
	} = event;

	// 下界岩
	createMixing('minecraft:netherrack', [
		'#forge:cobblestone',
		Fluid.of('minecraft:lava', 500)
	])

	// 粉碎轮 => 碎矿
	createSplashing([
		Item.of('exnihilomekanism:osmium_pieces').withChance(0.05),
		Item.of('exnihilosequentia:iron_pieces').withChance(0.15),
		Item.of('exnihilosequentia:gold_pieces').withChance(0.15),
		Item.of('exnihilosequentia:lead_pieces').withChance(0.15),
		Item.of('exnihilosequentia:nickel_pieces').withChance(0.15),
		Item.of('exnihilosequentia:silver_pieces').withChance(0.15),
		Item.of('exnihilosequentia:tin_pieces').withChance(0.15),
		Item.of('exnihilosequentia:aluminum_pieces').withChance(0.15),
		Item.of('exnihilosequentia:platinum_pieces').withChance(0.15),
		Item.of('exnihilosequentia:zinc_pieces').withChance(0.15),
		Item.of('exnihilotinkers:cobalt_pieces').withChance(0.15),
		Item.of('exnihilosequentia:uranium_pieces').withChance(0.15),
		Item.of('exnihilosequentia:copper_pieces').withChance(0.15),
	], 'kubejs:mystery_gravel')

	createFilling('kubejs:semi_molten_orichalcum', [
		'tinkers_ingenuity:orichalcum_ingot',
		Fluid.of('tinkers_reforged:molten_blazing_copper', 810)
	])

	createMixing('kubejs:hephaestus_ingot', [
		'kubejs:unformed_hephaestus_ingot',
		'twilightforest:ice_bomb',
		'twilightforest:ice_bomb',
		'iceandfire:ice_dragon_heart',
		'mysticalagriculture:ice_seeds',
		'mysticalagriculture:ice_seeds',
		'twilightforest:snow_queen_trophy',
		'twilightforest:alpha_yeti_trophy',
	]).superheated()

	createCrushing([
		'powah:uraninite',
		Item.of('#forge:nuggets/uranium').withChance(0.1)
	], '#forge:ingots/uranium')

	createCrushing([
		'draconicevolution:small_chaos_frag',
	], 'avaritia:neutronium_block')

	createMechanicalCrafting('cyclic:glowing_helmet', [
		'GRARG',
		'GDRDG',
		'G   G',
		'G   G'
	], {
		G: 'cyclic:gem_amber',
		A: '#forge:ores/allthemodium',
		D: 'iceandfire:myrmex_desert_resin_block',
		R: 'mekanism:block_refined_glowstone'
	})

	createSequencedAssembly(
		"projecte:watch_of_flowing_time",
		"minecraft:clock",
		[
			createDeploying("minecraft:clock", [
				"minecraft:clock",
				"projecte:dark_matter_block",
			]),
			createDeploying("minecraft:clock", [
				"minecraft:clock",
				"rainbowcompound:shadow_mechanism",
			]),
			createDeploying("minecraft:clock", [
				"minecraft:clock",
				"tinkers_ingenuity:bedrock_alloy_ingot",
			]),
			createDeploying("minecraft:clock", [
				"minecraft:clock",
				"avaritia:neutronium_ingot",
			]),
		]).loops(3);

	createSequencedAssembly(
		"allthemodium:allthemodium_helmet",
		"mythicbotany:alfsteel_helmet",
		[
			createDeploying("mythicbotany:alfsteel_helmet", [
				"mythicbotany:alfsteel_helmet",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("mythicbotany:alfsteel_helmet", [
				"mythicbotany:alfsteel_helmet",
				"allthemodium:allthemodium_ingot",
			]),
			createDeploying("mythicbotany:alfsteel_helmet", [
				"mythicbotany:alfsteel_helmet",
				"minecraft:gold_block",
			]),
			createDeploying("mythicbotany:alfsteel_helmet", [
				"mythicbotany:alfsteel_helmet",
				"mekanism:module_electrolytic_breathing_unit",
			]),
			createDeploying("mythicbotany:alfsteel_helmet", [
				"mythicbotany:alfsteel_helmet",
				"cyclic:charm_stone",
			]),
		]).loops(5);

	createSequencedAssembly(
		"allthemodium:allthemodium_chestplate",
		"mythicbotany:alfsteel_chestplate",
		[
			createDeploying("mythicbotany:alfsteel_chestplate", [
				"mythicbotany:alfsteel_chestplate",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("mythicbotany:alfsteel_chestplate", [
				"mythicbotany:alfsteel_chestplate",
				"allthemodium:allthemodium_ingot",
			]),
			createDeploying("mythicbotany:alfsteel_chestplate", [
				"mythicbotany:alfsteel_chestplate",
				"minecraft:gold_block",
			]),
			createDeploying("mythicbotany:alfsteel_chestplate", [
				"mythicbotany:alfsteel_chestplate",
				"minecraft:netherite_block",
			]),
		]).loops(8);

	createSequencedAssembly(
		"allthemodium:allthemodium_leggings",
		"mythicbotany:alfsteel_leggings",
		[
			createDeploying("mythicbotany:alfsteel_leggings", [
				"mythicbotany:alfsteel_leggings",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("mythicbotany:alfsteel_leggings", [
				"mythicbotany:alfsteel_leggings",
				"allthemodium:allthemodium_ingot",
			]),
			createDeploying("mythicbotany:alfsteel_leggings", [
				"mythicbotany:alfsteel_leggings",
				"minecraft:gold_block",
			]),
			createDeploying("mythicbotany:alfsteel_leggings", [
				"mythicbotany:alfsteel_leggings",
				"mekaevolution:absolute_control_circuit",
			]),
		]).loops(7);

	createSequencedAssembly(
		"allthemodium:allthemodium_boots",
		"mythicbotany:alfsteel_boots",
		[
			createDeploying("mythicbotany:alfsteel_boots", [
				"mythicbotany:alfsteel_boots",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("mythicbotany:alfsteel_boots", [
				"mythicbotany:alfsteel_boots",
				"allthemodium:allthemodium_ingot",
			]),
			createDeploying("mythicbotany:alfsteel_boots", [
				"mythicbotany:alfsteel_boots",
				"minecraft:gold_block",
			]),
			createDeploying("mythicbotany:alfsteel_boots", [
				"mythicbotany:alfsteel_boots",
				"cyclic:charm_longfall",
			]),
		]).loops(4);

	createSequencedAssembly(
		"allthemodium:vibranium_helmet",
		"aquaculture:neptunium_helmet",
		[
			createDeploying("aquaculture:neptunium_helmet", [
				"aquaculture:neptunium_helmet",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("aquaculture:neptunium_helmet", [
				"aquaculture:neptunium_helmet",
				"allthemodium:vibranium_ingot",
			]),
			createDeploying("aquaculture:neptunium_helmet", [
				"aquaculture:neptunium_helmet",
				"minecraft:gold_block",
			]),
			createDeploying("aquaculture:neptunium_helmet", [
				"aquaculture:neptunium_helmet",
				"mekanism:module_electrolytic_breathing_unit",
			]),
			createDeploying("aquaculture:neptunium_helmet", [
				"aquaculture:neptunium_helmet",
				"cyclic:charm_stone",
			]),
		]).loops(5);

	createSequencedAssembly(
		"allthemodium:vibranium_chestplate",
		"aquaculture:neptunium_chestplate",
		[
			createDeploying("aquaculture:neptunium_chestplate", [
				"aquaculture:neptunium_chestplate",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("aquaculture:neptunium_chestplate", [
				"aquaculture:neptunium_chestplate",
				"allthemodium:vibranium_ingot",
			]),
			createDeploying("aquaculture:neptunium_chestplate", [
				"aquaculture:neptunium_chestplate",
				"minecraft:gold_block",
			]),
			createDeploying("aquaculture:neptunium_chestplate", [
				"aquaculture:neptunium_chestplate",
				"minecraft:netherite_block",
			]),
		]).loops(8);

	createSequencedAssembly(
		"allthemodium:vibranium_leggings",
		"aquaculture:neptunium_leggings",
		[
			createDeploying("aquaculture:neptunium_leggings", [
				"aquaculture:neptunium_leggings",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("aquaculture:neptunium_leggings", [
				"aquaculture:neptunium_leggings",
				"allthemodium:vibranium_ingot",
			]),
			createDeploying("aquaculture:neptunium_leggings", [
				"aquaculture:neptunium_leggings",
				"minecraft:gold_block",
			]),
			createDeploying("aquaculture:neptunium_leggings", [
				"aquaculture:neptunium_leggings",
				"cyclic:charm_magicdefense",
			]),
			createDeploying("aquaculture:neptunium_leggings", [
				"aquaculture:neptunium_leggings",
				"mysticalagriculture:wither_resistance_augment",
			]),
			createDeploying("aquaculture:neptunium_leggings", [
				"aquaculture:neptunium_leggings",
				"minecraft:pufferfish",
			]),
		]).loops(7);

	createSequencedAssembly(
		"allthemodium:vibranium_boots",
		"aquaculture:neptunium_boots",
		[
			createDeploying("aquaculture:neptunium_boots", [
				"aquaculture:neptunium_boots",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("aquaculture:neptunium_boots", [
				"aquaculture:neptunium_boots",
				"allthemodium:vibranium_ingot",
			]),
			createDeploying("aquaculture:neptunium_boots", [
				"aquaculture:neptunium_boots",
				"minecraft:gold_block",
			]),
			createDeploying("aquaculture:neptunium_boots", [
				"aquaculture:neptunium_boots",
				"cyclic:charm_longfall",
			]),
		]).loops(4);

	createSequencedAssembly(
		"allthemodium:unobtainium_helmet",
		"gobber2:gobber2_helmet_dragon",
		[
			createDeploying("gobber2:gobber2_helmet_dragon", [
				"gobber2:gobber2_helmet_dragon",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("gobber2:gobber2_helmet_dragon", [
				"gobber2:gobber2_helmet_dragon",
				"allthemodium:unobtainium_ingot",
			]),
			createDeploying("gobber2:gobber2_helmet_dragon", [
				"gobber2:gobber2_helmet_dragon",
				"minecraft:gold_block",
			]),
			createDeploying("gobber2:gobber2_helmet_dragon", [
				"gobber2:gobber2_helmet_dragon",
				"mekanism:module_electrolytic_breathing_unit",
			]),
			createDeploying("gobber2:gobber2_helmet_dragon", [
				"gobber2:gobber2_helmet_dragon",
				"cyclic:charm_stone",
			]),
		]).loops(5);

	createSequencedAssembly(
		"allthemodium:unobtainium_chestplate",
		"gobber2:gobber2_chestplate_dragon",
		[
			createDeploying("gobber2:gobber2_chestplate_dragon", [
				"gobber2:gobber2_chestplate_dragon",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("gobber2:gobber2_chestplate_dragon", [
				"gobber2:gobber2_chestplate_dragon",
				"allthemodium:unobtainium_ingot",
			]),
			createDeploying("gobber2:gobber2_chestplate_dragon", [
				"gobber2:gobber2_chestplate_dragon",
				"minecraft:gold_block",
			]),
			createDeploying("gobber2:gobber2_chestplate_dragon", [
				"gobber2:gobber2_chestplate_dragon",
				"minecraft:netherite_block",
			]),
		]).loops(8);

	createSequencedAssembly(
		"allthemodium:unobtainium_leggings",
		"gobber2:gobber2_leggings_dragon",
		[
			createDeploying("gobber2:gobber2_leggings_dragon", [
				"gobber2:gobber2_leggings_dragon",
				"minecraft:pufferfish",
			]),
			createDeploying("gobber2:gobber2_leggings_dragon", [
				"gobber2:gobber2_leggings_dragon",
				"allthemodium:unobtainium_ingot",
			]),
			createDeploying("gobber2:gobber2_leggings_dragon", [
				"gobber2:gobber2_leggings_dragon",
				"minecraft:gold_block",
			]),
			createDeploying("gobber2:gobber2_leggings_dragon", [
				"gobber2:gobber2_leggings_dragon",
				"cyclic:charm_magicdefense",
			]),
			createDeploying("gobber2:gobber2_leggings_dragon", [
				"gobber2:gobber2_leggings_dragon",
				"mysticalagriculture:wither_resistance_augment",
			]),
			createDeploying("gobber2:gobber2_leggings_dragon", [
				"gobber2:gobber2_leggings_dragon",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("gobber2:gobber2_leggings_dragon", [
				"gobber2:gobber2_leggings_dragon",
				"rainbowcompound:chorusite_ingot",
			]),
		]).loops(7);

	createSequencedAssembly(
		"allthemodium:unobtainium_boots",
		"gobber2:gobber2_boots_dragon",
		[
			createDeploying("gobber2:gobber2_boots_dragon", [
				"gobber2:gobber2_boots_dragon",
				"tinkerscalibration:mangobberslime_ingot",
			]),
			createDeploying("gobber2:gobber2_boots_dragon", [
				"gobber2:gobber2_boots_dragon",
				"allthemodium:unobtainium_ingot",
			]),
			createDeploying("gobber2:gobber2_boots_dragon", [
				"gobber2:gobber2_boots_dragon",
				"minecraft:gold_block",
			]),
			createDeploying("gobber2:gobber2_boots_dragon", [
				"gobber2:gobber2_boots_dragon",
				"cyclic:charm_longfall",
			]),
		]).loops(4);

	createSequencedAssembly(
		"projecte:dm_helmet",
		"rainbowcompound:obsidianite_helmet",
		[
			createDeploying("rainbowcompound:obsidianite_helmet", [
				"rainbowcompound:obsidianite_helmet",
				"mekanism:pellet_plutonium",
			]),
			createDeploying("rainbowcompound:obsidianite_helmet", [
				"rainbowcompound:obsidianite_helmet",
				"mekanism:pellet_polonium",
			]),
			createDeploying("rainbowcompound:obsidianite_helmet", [
				"rainbowcompound:obsidianite_helmet",
				"projecte:dark_matter_block",
			]),
		]).loops(5);

	createSequencedAssembly(
		"projecte:dm_chestplate",
		"rainbowcompound:obsidianite_chestplate",
		[
			createDeploying("rainbowcompound:obsidianite_chestplate", [
				"rainbowcompound:obsidianite_chestplate",
				"mekanism:pellet_plutonium",
			]),
			createDeploying("rainbowcompound:obsidianite_chestplate", [
				"rainbowcompound:obsidianite_chestplate",
				"mekanism:pellet_polonium",
			]),
			createDeploying("rainbowcompound:obsidianite_chestplate", [
				"rainbowcompound:obsidianite_chestplate",
				"projecte:dark_matter_block",
			]),
		]).loops(8);

	createSequencedAssembly(
		"projecte:dm_leggings",
		"rainbowcompound:obsidianite_leggings",
		[
			createDeploying("rainbowcompound:obsidianite_leggings", [
				"rainbowcompound:obsidianite_leggings",
				"mekanism:pellet_plutonium",
			]),
			createDeploying("rainbowcompound:obsidianite_leggings", [
				"rainbowcompound:obsidianite_leggings",
				"mekanism:pellet_polonium",
			]),
			createDeploying("rainbowcompound:obsidianite_leggings", [
				"rainbowcompound:obsidianite_leggings",
				"projecte:dark_matter_block",
			]),
		]).loops(7);

	createSequencedAssembly(
		"projecte:dm_boots",
		"rainbowcompound:obsidianite_boots",
		[
			createDeploying("rainbowcompound:obsidianite_boots", [
				"rainbowcompound:obsidianite_boots",
				"mekanism:pellet_plutonium",
			]),
			createDeploying("rainbowcompound:obsidianite_boots", [
				"rainbowcompound:obsidianite_boots",
				"mekanism:pellet_polonium",
			]),
			createDeploying("rainbowcompound:obsidianite_boots", [
				"rainbowcompound:obsidianite_boots",
				"projecte:dark_matter_block",
			]),
		]).loops(4);

	createSequencedAssembly(
		"projecte:gem_helmet",
		"projecte:dm_helmet",
		[
			createFilling("projecte:dm_helmet", [
				"projecte:dm_helmet",
				Fluid.of("allthemodium:molten_allthemodium", 90),
			]),
			createDeploying("projecte:dm_helmet", [
				"projecte:dm_helmet",
				"projecte:red_matter_block",
			]),
			createDeploying("projecte:dm_helmet", [
				"projecte:dm_helmet",
				"avaritia:crystal_matrix_block",
			]),
			createDeploying("projecte:dm_helmet", [
				"projecte:dm_helmet",
				"ae2:singularity",
			]),
		]).loops(10);

	createSequencedAssembly(
		"projecte:gem_chestplate",
		"projecte:dm_chestplate",
		[
			createFilling("projecte:dm_chestplate", [
				"projecte:dm_chestplate",
				Fluid.of("twilightforest:fiery_essence", 300),
			]),
			createDeploying("projecte:dm_chestplate", [
				"projecte:dm_chestplate",
				"projecte:red_matter_block",
			]),
			createDeploying("projecte:dm_chestplate", [
				"projecte:dm_chestplate",
				"projecte:nova_cataclysm",
			]),
			createDeploying("projecte:dm_chestplate", [
				"projecte:dm_chestplate",
				"ae2:singularity",
			]),
		]).loops(16);

	createSequencedAssembly(
		"projecte:gem_leggings",
		"projecte:dm_leggings",
		[
			createFilling("projecte:dm_leggings", [
				"projecte:dm_leggings",
				Fluid.of("industrialforegoing:ether_gas", 1000,),
			]),
			createDeploying("projecte:dm_leggings", [
				"projecte:dm_leggings",
				"projecte:red_matter_block",
			]),
			createDeploying("projecte:dm_leggings", [
				"projecte:dm_leggings",
				"tinkerscalibration:gravity_ingot",
			]),
			createDeploying("projecte:dm_leggings", [
				"projecte:dm_leggings",
				"ae2:singularity",
			]),
		]).loops(14);

	createSequencedAssembly(
		"projecte:gem_boots",
		"projecte:dm_boots",
		[
			createDeploying("projecte:dm_boots", [
				"projecte:dm_boots",
				"projecte:red_matter_block",
			]),
			createDeploying("projecte:dm_boots", [
				"projecte:dm_boots",
				"mekanism:module_gravitational_modulating_unit",
			]),
		]).loops(2);

	//半成蛋糕
	createSequencedAssembly(
		"kubejs:incomplete_creative_blaze_cake",
		"create:blaze_cake",
		[
			createFilling("create:blaze_cake", [
				"create:blaze_cake",
				Fluid.of("minecraft:lava", 1000)
			]),
			createFilling("create:blaze_cake", [
				"create:blaze_cake",
				Fluid.of("tconstruct:blazing_blood", 1000)
			]),
			createFilling("create:blaze_cake", [
				"create:blaze_cake",
				Fluid.of("tinkers_reforged:molten_blazing_copper", 1000)
			]),
			createFilling("create:blaze_cake", [
				"create:blaze_cake",
				Fluid.of("twilightforest:fiery_essence", 1000)
			]), createFilling("create:blaze_cake", [
				"create:blaze_cake",
				Fluid.of("tinkers_reforged:molten_proto_lava", 1000)
			]),
			createFilling("create:blaze_cake", [
				"create:blaze_cake",
				Fluid.of("allthemodium:soul_lava", 1000)
			])
		]).loops(16);
})